%------------------------------------------------------------------------------
% File     : SEV070^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory (Relations)
% Problem  : TPS problem THM577
% Version  : Especial.
% English  : Inductive defn of <= on naturals is transitive.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0476 [Bro09]
%          : THM577 [TPS]

% Status   : Theorem
% Rating   : 0.08 v7.4.0, 0.00 v6.2.0, 0.17 v6.1.0, 0.00 v5.1.0, 0.25 v5.0.0, 0.00 v4.0.1, 0.33 v4.0.0
% Syntax   : Number of formulae    :    2 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :   27 (   0 equality;  24 variable)
%            Maximal formula depth :   13 (   8 average)
%            Number of connectives :   26 (   0   ~;   0   |;   4   &;  15   @)
%                                         (   0 <=>;   7  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    3 (   1   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   9   !;   0   ?;   0   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%------------------------------------------------------------------------------
thf(cS,type,(
    cS: $i > $i )).

thf(cTHM577_pme,conjecture,(
    ! [Xx: $i,Xy: $i,Xz: $i] :
      ( ( ! [Xp: $i > $o] :
            ( ( ( Xp @ Xx )
              & ! [Xn: $i] :
                  ( ( Xp @ Xn )
                 => ( Xp @ ( cS @ Xn ) ) ) )
           => ( Xp @ Xy ) )
        & ! [Xp: $i > $o] :
            ( ( ( Xp @ Xy )
              & ! [Xn: $i] :
                  ( ( Xp @ Xn )
                 => ( Xp @ ( cS @ Xn ) ) ) )
           => ( Xp @ Xz ) ) )
     => ! [Xp: $i > $o] :
          ( ( ( Xp @ Xx )
            & ! [Xn: $i] :
                ( ( Xp @ Xn )
               => ( Xp @ ( cS @ Xn ) ) ) )
         => ( Xp @ Xz ) ) ) )).

%------------------------------------------------------------------------------
